<?php
defined('BASEPATH') OR exit('No direct script access allowed');
header("Access-Control-Allow-Headers: Authorization, Content-Type");
header("Access-Control-Allow-Origin: *");
header('content-type: application/json; charset=utf-8');	

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

// New Shopify Api
use Osiset\BasicShopifyAPI\BasicShopifyAPI;
use Osiset\BasicShopifyAPI\Options;
use Osiset\BasicShopifyAPI\Session;


class PostController extends CI_Controller {
	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	public  $api,$shopData;
	public $shop;
	public function __construct()
	{
		parent::__construct();// you have missed this line.
		
		
		$options = new Options();
		$options->setVersion(SHOPIYF_VERSION);
		$options->setApiKey(SHOPIFY_API_KEY);
		$options->setApiSecret(SHOPIFY_SECRET_KEY);
		// Create the client and session
		$this->api = new BasicShopifyAPI($options);
		ini_set('display_errors', 1);
	}
	
	function postOffer(){
		$productData=[];
	    $jwt= $_POST['token'];
	    $key= SHOPIFY_SECRET_KEY;
	    $decoded = JWT::decode($jwt, new Key($key, 'HS256'));

	    $this->shop=$domain=$decoded->input_data->shop->domain;
	    $inputData =$decoded->input_data;
	  //  echo json_encode($inputData->initialPurchase);
	    $initialPurchase= $inputData->initialPurchase;

	    $total= $initialPurchase->totalPriceSet->shopMoney->amount;
	    $lineItem=$initialPurchase->lineItems;
	   
	    
	    //$getOffers=$this->adminModel->get_data('funnels',["shop_name"=>$this->shop]);
	    //198.00
	    $offers=[];
	        $shopData=$this->adminModel->get_row("app_record",array("shop_address"=>$domain));
	    $this->api->setSession(new Session($domain, $shopData->shop_token));
	    $productData=[];
	    $condition=["shop_name"=>$this->shop,'location'=>"postPurches"];
	    
	    $whereOn=array_merge($condition,["triggerOn"=>"minValue","minValue<="=>$total,"status"=>1]);
	    $getOffers=$this->adminModel->get_data('funnels',$whereOn);
		if($getOffers){
		    foreach($getOffers as $keys){
		    	$offer=json_decode($keys->offer);
		    	$id=base64_encode($keys->id);
		    	
		    	$products=$offer->offerProduct?$this->getProducts($offer->offerProduct,$offer):[];
		    	if(!empty($products)){
		    		$offers=array_merge($offers,$products);
		    		//print_r($offers);
		    		//array_push($offers, $products);
		    		//$offers[]=$products;
		    	}
		    	//$offers[]=["id"=>$id,"funnelName"=>$keys->funnelName,"offer"=>$offer,"design"=>json_decode($keys->design),"settings"=>json_decode($keys->settings),"language"=>json_decode($keys->language),"products"=>$products];
		    	
		    }
	    }

	    if(!empty($lineItem)){
		   		$whereOnIds=array_merge($condition,["triggerOn"=>"products","status"=>1]);
		   		foreach( $lineItem as $item){
		   			$id= $item->product->id;
		   			$searchKey=array_search($id, array_column($offers, 'id'));
				    	if($searchKey>-1){
				    		continue;
				    	}
		   			$keys=$this->adminModel->get_front_row('funnels',$whereOnIds,["recommendedProduct"=>$id]);
		   			if($keys){
			   			$id=base64_encode($keys->id);
				    	$offer=json_decode($keys->offer);
				    	//$offers[$id]=["id"=>$id,"funnelName"=>$keys->funnelName,"offer"=>json_decode($keys->offer),"design"=>json_decode($keys->design),"settings"=>json_decode($keys->settings),"language"=>json_decode($keys->language)];

				    	$products=$offer->offerProduct?$this->getProducts($offer->offerProduct,$offer):[];
				    	if(!empty($products)){
				    		$offers=array_merge($offers,$products);//$offers[]=$products;//array_push($offers, $products);
				    	}
			    	}
			    	//$offers[$id]["products"]=$products;
		   		}

		   		
		   	}


	    echo json_encode(["products"=>$offers]);

	    die();
	   	// foreach($getOffers as $value){
	   	// 	$offer=json_decode($value->offer);
	   	// }

	   	$offer=json_decode($getOffers->offer);
	   
	   	$result = $this->api->rest("get","/admin/api/products.json",["ids"=>$offer->offerProduct ,"fields"=>"id,title,handle,images,options,variants,body_html","status"=>"active"]);
	  
	    $result=$this->adminModel->getBodyContainer($result,'products');
		foreach($result as $value){
			$value["body_html"]=strip_tags($value["body_html"]);
			$value["discount"]=['discountValue'=>$offer->discountValue,"type"=>$offer->discount,"minQty"=>$offer->minQty];
			$inventory=false;
			$variants=[];
			foreach($value["variants"] as $variant){
				if($variant['inventory_quantity']>0){
					array_push($variants,$variant);
					$inventory=true;
				}
			}
			if($inventory){
				$value["variants"]=$variants;
				array_push($productData, $value);
			}

		}


		
	}

	private function getProducts ($ids,$offer){
		$productData=[];
		$result = $this->api->rest("get","/admin/api/products.json",["ids"=>$ids,"fields"=>"id,title,handle,images,options,variants,body_html","status"=>"active"]);
	  
	 	$result=$this->adminModel->getBodyContainer($result,'products');
	 	foreach($result as $value){
			$value["body_html"]=strip_tags($value["body_html"]);
			$value["discount"]=['discountValue'=>$offer->discountValue,"type"=>$offer->discount,"minQty"=>$offer->minQty];
			$inventory=false;
			$variants=[];
			foreach($value["variants"] as $variant){
				if($variant['inventory_quantity']>0 || $variant['inventory_quantity']<0){
					array_push($variants,$variant);
					$inventory=true;
				}
			}
			if($inventory){
				$value["variants"]=$variants;
				array_push($productData, $value);
			}

		}

		return $productData;
	}

	function signChangeset(){
		$jwt= $_POST['token'];
	    $key= SHOPIFY_SECRET_KEY;
		$decoded = JWT::decode($jwt, new Key($key, 'HS256'));
		
		$decodedReferenceId=$decoded->input_data->initialPurchase->referenceId;
		$referenceId=$_POST['referenceId'];
		$status=$referenceId==$decodedReferenceId?true:false;
		
		$payload = [
		    'iss' => SHOPIFY_API_KEY,
		    'jti' => $this->v4(),
		    'name'=> "enormapps",
		    'iat' => time(),
		    'sub' =>$referenceId,
		    "changes"=>json_decode($_POST['changes'])
		    
		];

		//echo json_encode($payload);

		$token = JWT::encode($payload, $key, 'HS256');
		echo json_encode(["token"=>$token]);
	}

	public function v4() {
	    return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',

	      // 32 bits for "time_low"
	      mt_rand(0, 0xffff), mt_rand(0, 0xffff),

	      // 16 bits for "time_mid"
	      mt_rand(0, 0xffff),

	      // 16 bits for "time_hi_and_version",
	      // four most significant bits holds version number 4
	      mt_rand(0, 0x0fff) | 0x4000,

	      // 16 bits, 8 bits for "clk_seq_hi_res",
	      // 8 bits for "clk_seq_low",
	      // two most significant bits holds zero and one for variant DCE1.1
	      mt_rand(0, 0x3fff) | 0x8000,

	      // 48 bits for "node"
	      mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
	    );
	 }

	
}
