<?php $this->load->view("include/header")?>
<link rel="stylesheet" type="text/css" href="<?=base_url('/app-assets/css/pages/page-pricing.min.css')?>">
<!-- <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet"> -->
<script src="https://unpkg.com/vue@3.2.36/dist/vue.global.js"></script>
  <!-- BEGIN: Content-->
<div class="app-content content " id="funnesl_setting">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
        </div>
        <div class="content-body">
            <section id="pricing-plan">
                <!-- title text and switch button -->
                <div class="text-center">
                    <h1 class="mt-5">Pricing Plans</h1>
                    <p class="mb-2 pb-75">
                        All plans include 40+ advanced tools and features to boost your product. Choose the best plan to fit your needs.
                    </p>
                    <div class="d-flex align-items-center justify-content-center mb-5 pb-50">
                        <h6 class="me-1 mb-0">Monthly</h6>
                        <div class="form-check form-switch">
                            <input type="checkbox" class="form-check-input" id="priceSwitch" />
                            <label class="form-check-label" for="priceSwitch"></label>
                        </div>
                        <h6 class="ms-50 mb-0">Annually</h6>
                    </div>
                </div>
                <!--/ title text and switch button -->

                <!-- pricing plan cards -->
                <div class="row pricing-card">
                    <div class="col-12 col-sm-offset-2 col-sm-10 col-md-12 col-lg-offset-2 col-lg-10 mx-auto">
                        <div class="row">
                            <!-- basic plan -->
                            <div class="col-12 col-md-4">
                                <div class="card basic-pricing text-center">
                                    <div class="card-body">
                                        <img src="<?=base_url()?>app-assets/images/illustration/Pot1.svg" class="mb-2 mt-5" alt="svg img" />
                                        <h3>Basic</h3>
                                        <p class="card-text">A simple start for everyone</p>
                                        <div class="annual-plan">
                                            <div class="plan-price mt-2">
                                                <sup class="font-medium-1 fw-bold text-primary">$</sup>
                                                <span class="pricing-basic-value fw-bolder text-primary">0</span>
                                                <sub class="pricing-duration text-body font-medium-1 fw-bold">/month</sub>
                                            </div>
                                            <small class="annual-pricing d-none text-muted"></small>
                                        </div>
                                        <ul class="list-group list-group-circle text-start">
                                            <li class="list-group-item">100 responses a month</li>
                                            <li class="list-group-item">Unlimited forms and surveys</li>
                                            <li class="list-group-item">Unlimited fields</li>
                                            <li class="list-group-item">Basic form creation tools</li>
                                            <li class="list-group-item">Up to 2 subdomains</li>
                                        </ul>
                                        <button class="btn w-100 btn-outline-success mt-2">Your current plan</button>
                                    </div>
                                </div>
                            </div>
                            <!--/ basic plan -->

                            <!-- standard plan -->
                            <div class="col-12 col-md-4">
                                <div class="card standard-pricing popular text-center">
                                    <div class="card-body">
                                        <div class="pricing-badge text-end">
                                            <span class="badge rounded-pill badge-light-primary">Popular</span>
                                        </div>
                                        <img src="<?=base_url()?>app-assets/images/illustration/Pot2.svg" class="mb-1" alt="svg img" />
                                        <h3>Standard</h3>
                                        <p class="card-text">For small to medium businesses</p>
                                        <div class="annual-plan">
                                            <div class="plan-price mt-2">
                                                <sup class="font-medium-1 fw-bold text-primary">$</sup>
                                                <span class="pricing-standard-value fw-bolder text-primary">49</span>
                                                <sub class="pricing-duration text-body font-medium-1 fw-bold">/month</sub>
                                            </div>
                                            <small class="annual-pricing d-none text-muted"></small>
                                        </div>
                                        <ul class="list-group list-group-circle text-start">
                                            <li class="list-group-item">Unlimited responses</li>
                                            <li class="list-group-item">Unlimited forms and surveys</li>
                                            <li class="list-group-item">Instagram profile page</li>
                                            <li class="list-group-item">Google Docs integration</li>
                                            <li class="list-group-item">Custom “Thank you” page</li>
                                        </ul>
                                        <button class="btn w-100 btn-primary mt-2">Upgrade</button>
                                    </div>
                                </div>
                            </div>
                            <!--/ standard plan -->

                            <!-- enterprise plan -->
                            <div class="col-12 col-md-4">
                                <div class="card enterprise-pricing text-center">
                                    <div class="card-body">
                                        <img src="<?=base_url()?>app-assets/images/illustration/Pot3.svg" class="mb-2" alt="svg img" />
                                        <h3>Enterprise</h3>
                                        <p class="card-text">Solution for big organizations</p>
                                        <div class="annual-plan">
                                            <div class="plan-price mt-2">
                                                <sup class="font-medium-1 fw-bold text-primary">$</sup>
                                                <span class="pricing-enterprise-value fw-bolder text-primary">99</span>
                                                <sub class="pricing-duration text-body font-medium-1 fw-bold">/month</sub>
                                            </div>
                                            <small class="annual-pricing d-none text-muted"></small>
                                        </div>
                                        <ul class="list-group list-group-circle text-start">
                                            <li class="list-group-item">PayPal payments</li>
                                            <li class="list-group-item">Logic Jumps</li>
                                            <li class="list-group-item">File upload with 5GB storage</li>
                                            <li class="list-group-item">Custom domain support</li>
                                            <li class="list-group-item">Stripe integration</li>
                                        </ul>
                                        <button class="btn w-100 btn-outline-primary mt-2">Upgrade</button>
                                    </div>
                                </div>
                            </div>
                            <!--/ enterprise plan -->
                        </div>
                    </div>
                </div>
                <!--/ pricing plan cards -->

                <!-- pricing free trial -->
                <div class="pricing-free-trial">
                    <div class="row">
                        <div class="col-12 col-lg-10 col-lg-offset-3 mx-auto">
                            <div class="pricing-trial-content d-flex justify-content-between">
                                <div class="text-center text-md-start mt-3">
                                    <h3 class="text-primary">Still not convinced? Start with a 14-day FREE trial!</h3>
                                    <h5>You will get full access to with all the features for 14 days.</h5>
                                    <button class="btn btn-primary mt-2 mt-lg-3">Start 14-day FREE trial</button>
                                </div>

                                <!-- image -->
                                <img src="<?=base_url()?>app-assets/images/illustration/pricing-Illustration.svg" class="pricing-trial-img img-fluid" alt="svg img" />
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ pricing free trial -->

               
            </section>

        </div>
    </div>
</div>
<!-- END: Content-->
<?php $this->load->view("include/footer")?>