<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'auth';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
//$route["admin/logout"]="Auth/logout";
$route["login"]="Auth/login";
$route['admin']="admin/DashboardController/redirectToDashboard";
$route['admin/dashboard']="admin/DashboardController";

//Admin Funnel Controllers
$route['admin/funnel/list']="admin/FunnelController/list";
$route['admin/funnel/create-funnel']="admin/FunnelController/setting";
$route['admin/funnel/edit-funnel/(:num)']="admin/FunnelController/setting/$1";
$route['admin/funnel/setting/(:num)']="admin/FunnelController/setting/$1";


// Admin pages controllers
$route['admin/faq']="admin/PagesController/faq";
$route['admin/install']="admin/PagesController/install";
$route['admin/contact-us']="admin/PagesController/contactUs";
$route['admin/pricing']="admin/PagesController/pricing";


//Api funnel controller

$route["admin/api/funnel/save"]="api/FunnelController/saveFunnel";
// new setting funnel save
$route["admin/api/funnel/save-settings"]="api/FunnelController/saveFunnelSettings";

$route["admin/api/funnel/list"]="api/FunnelController/funnelList";
$route["admin/api/funnel/get-funnel-details/(:num)"]="api/FunnelController/funnelDetails/$1";
$route["admin/api/funnel/delete/(:num)"]="api/FunnelController/funnelDelete/$1";
$route["admin/api/funnel/products"]="api/FunnelController/products";


$route["admin/api/contact-us"]="admin/PagesController/contactUsSend";

// Authorization
$route['app/check']="LogController";
$route['app/check-x']="LogController";
//App Plan Controller
$route["api/products"]["post"]= "api/FrontController/products";
$route["api/get-products"]["post"]= "api/FrontController/getByProducts";
$route["api/checkout"]["post"]= "api/FrontController/checkout";
$route["api/offer"]= "api/PostController/postOffer";
$route["api/sign-changeset"]= "api/PostController/signChangeset";


$route['webhook/shop-erasure'] =  'Webhook/shopErasure';
$route['webhook/customer-erasure'] =  'Webhook/customerErasure';
$route['webhook/customer-data'] =  'Webhook/customerData';
