<?php defined('BASEPATH') OR exit('No direct script access allowed'); 
header("Access-Control-Allow-Headers: Authorization, Content-Type");
header("Access-Control-Allow-Origin: *");
header('content-type: application/json; charset=utf-8');
// New Shopify Api
use Osiset\BasicShopifyAPI\BasicShopifyAPI;
use Osiset\BasicShopifyAPI\Options;
use Osiset\BasicShopifyAPI\Session;

class Webhook extends CI_Controller { 
	public $api;
	public $shop,$token;
	public function __construct()
	{
		parent::__construct();// you have missed this line.
		// Create options for the API
		$options = new Options();
		$options->setVersion(SHOPIYF_VERSION);
		$options->setApiKey(SHOPIFY_API_KEY);
		$options->setApiSecret(SHOPIFY_SECRET_KEY);
		// Create the client and session
		$this->api = new BasicShopifyAPI($options); 

		$this->shop = $this->input->get('shop');
		$getRow =$this->adminModel->get_row("app_record",array("shop_address"=>$this->shop));			
		if($getRow){
		$this->token = $getRow->shop_token;
			($this->token && $this->shop)?$this->api->setSession(new Session($this->shop   , $this->token)):'';
		}
	}  

	

	
	public function shopErasure()
	{
		// code...
		$hmac_header =$_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'];//'/B8g8sNZt5FnbbUy/ZM/xeqFTM4bRxcrMiibfEmc'; //'ux+LnjWf9O75ViY6itGGcThpW/k/gpH/24rYCGfI'; //$_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'];
		$data = file_get_contents('php://input');
	
		$verified = $this->verify_webhook($data, $hmac_header);

		//error_log('Webhook verified: '.var_export($verified, true)); // Check error.log to see the result
		if ($verified) {
			$data=json_decode($data);
			$this->adminModel->deleterows("app_record",array("shop_address"=>$data->shop_domain));
			# Process webhook payload
			# ...
			//$data=["message"=>"Successfuly Erasure"];
			http_response_code(200);
			//echo json_encode($data);
		} else {
			http_response_code(401);
		}
		
	}

	public function customerErasure()
	{
		$hmac_header = $_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'];
		$data = file_get_contents('php://input');
		$method= $_SERVER['REQUEST_METHOD'];
		$insert=[
			"method"=>$method,
			"hmac"=>$hmac_header,
			"data"=>$data,
			"type"=>"customerErasure"
		];
		$this->adminModel->insert_and_update_data("webookgdp",$insert);	
		$verified = $this->verify_webhook($data, $hmac_header);
		//error_log('Webhook verified: '.var_export($verified, true)); // Check error.log to see the result
		if ($verified) {
			//$data=json_decode($data);
			//$this->adminModel->deleterows("app_record",array("shop_address"=>$data->shop_domain));
			# Process webhook payload
			# ...
			//$data=["message"=>"Successfuly Erasure"];
			http_response_code(200);
			//echo json_encode($data);
		} else {
			http_response_code(401);
		}
	}
	public function customerData()
	{
		$hmac_header = $_SERVER['HTTP_X_SHOPIFY_HMAC_SHA256'];
		$data = file_get_contents('php://input');
		
		$method= $_SERVER['REQUEST_METHOD'];
		$insert=[
			"method"=>$method,
			"hmac"=>$hmac_header,
			"data"=>$data,
			"type"=>"customerData"
		];
		$this->adminModel->insert_and_update_data("webookgdp",$insert);
		$verified = $this->verify_webhook($data, $hmac_header);
		//error_log('Webhook verified: '.var_export($verified, true)); // Check error.log to see the result
		if ($verified) {
			# Process webhook payload
			# ...
			http_response_code(200);
		
		} else {
			http_response_code(401);
		}
		
	}

	function verify_webhook($data, $hmac_header)
	{
		$calculated_hmac = base64_encode(hash_hmac('sha256', $data, SHOPIFY_SECRET_KEY, true));
		$check=hash_equals($calculated_hmac, $hmac_header);
		if($check){
			return $check;
		}else{
			$stci=substr($calculated_hmac, 0, -4);
			return hash_equals($stci, $hmac_header);
		}
		
	}
}	
