<?php

if (!function_exists('getQueryStringParameters')) {
    /**
     * Get url parameters and return them
     * @param bool $array
     * @return array
     */
    function getQueryStringParameters($array = false) {
        $ci =& get_instance();
        $hmac = $ci->input->get('hmac');
        $locale = $ci->input->get('locale');
        $session = $ci->input->get('session');
        $shop = $ci->input->get('shop');
        $host = $ci->input->get('host');
        $shopId = $ci->input->get('shopid');
        $timestamp = $ci->input->get('timestamp');

        $id_token=$ci->input->get('id_token')??$ci->input->get('authorization');    
        $parameters = array();
        if (!empty($hmac)) {
            $parameters['hmac'] = $hmac;
        }

        if (!empty($locale)) {
            $parameters['locale'] = $locale;
        }

        if (!empty($session)) {
            $parameters['session'] = $session;
        }

        if (!empty($shop)) {
            $parameters['shop'] = $shop;
        }

        if (!empty($shop)) {
            $parameters['shopid'] = $shopId;
        }

         if (!empty($id_token)) {
            $parameters['authorization'] = $id_token;
        }
        if (!empty($shop)) {
            $parameters['host'] = $host;
        }

        if (!empty($timestamp)) {
            $parameters['timestamp'] = $timestamp;
        }


        // If response type is false then return it with http_build_query
        if (!$array) {
            $parameters = http_build_query($parameters);
        }

        return $parameters;
    }
}