<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class AdminModel extends CI_Model {

  public function __construct()
  {
    parent::__construct();
    $this->db->reconnect();
  }

  // Get single row data
  public function get_row($table,$where_and=null,$where_or=null)
  {
      if($where_and){
        $this->db->where($where_and);
      }
      
      if($where_or){
        $this->db->or_where($where_or);
      }
      $query = $this->db->get($table);
      if($query->num_rows() > 0) {
          return $query->row();
      } else { 
          return FALSE;
      }
  }

  // Insert and Update function
  public function insert_and_update_data($table,$data,$update=NULL)
  {
    if($update)
    {   
      return $this->update($data,$table,$update);
      
    }
    else
    {
      $this->insert($data, $table);
      return $lastinsertid =$this->db->insert_id();
    }
  }

  //Insert data 
  public function insert($data, $table)
  {   
    $this->db->set($data);
    if($this->db->insert($table))
    {
      return TRUE;
    }
    return FALSE;

  }

  //Update Data
  protected function update($data,$table, $update)
  {
    $this->db->where($update);
    if($this->db->update($table, $data) !== FALSE)
    {
      return TRUE;
    }
    return FALSE;
  }

  //Update Data
  function update_by_in($data,$table, $update)
  {
    $this->db->where_in("id",$update);
    if($this->db->update($table, $data) !== FALSE)
    {
      return TRUE;
    }
    return FALSE;
  }

  // get all data
  public function get_data($table,$where_and=null,$where_or=null,$like=null,$start=null,$showing=null,$order=null )
  {
      if($where_and){
      $this->db->where($where_and);
      }
      if($where_or){
        $this->db->group_start();
        $this->db->or_where($where_or);
        $this->db->group_end();
      }

      if($like){
        $this->db->group_start();
        $this->db->or_like($like);
        $this->db->group_end();
      }

      if($showing){
        $this->db->limit($showing,$start);
      } 

      if($order){
        $this->db->order_by($order);
      }

      $query = $this->db->get($table);
      if($query->num_rows() > 0) {
          return $query->result();
      } else { 
          return FALSE;
      }
      
  }
  public function get_front_row($table,$where_and=null,$like=null,$where_or=null,$select=null){
      if($select){
        $this->db->select($select);
      }
      if($where_and){
        $this->db->where($where_and);
      }
      if($like){
        $this->db->group_start();
        $this->db->like($like);
        $this->db->group_end();
      }
      if($where_or){
        $this->db->group_start();
        $this->db->or_where($where_or);
        $this->db->group_end();
      }
    
      $query = $this->db->get($table);
      if($query->num_rows() > 0) {
          return $query->row();
      } else { 
          return FALSE;
      }
   
  }
  public function get_front_data($table,$where_and=null,$where_or=null,$select=null,$like=null,$start=null,$showing=null,$order=null )
  {
      if($select){
        $this->db->select($select);
      }
      if($where_and){
      $this->db->where($where_and);
      }
      if($where_or){
        $this->db->group_start();
        $this->db->or_where($where_or);
        $this->db->group_end();
      }

      if($like){
        $this->db->group_start();
        $this->db->or_like($like);
        $this->db->group_end();
      }

      if($showing){
        $this->db->limit($showing,$start);
      } 

      if($order){
        $this->db->order_by($order);
      }

      $query = $this->db->get($table);
      if($query->num_rows() > 0) {
          return $query->result();
      } else { 
          return FALSE;
      }
      
  }

  

  // get all data by query
  function get_all_data($query){
    $query=$this->db->query($query);
    if($query->num_rows() > 0) {
        return $query->result();
    } else { 
        return FALSE;
    }
  }

  // count rows
  function getrows($table,$where_and=null,$where_or=null,$like=null){
      if($where_and){
      $this->db->where($where_and);
      }

      if($where_or){
        $this->db->group_start();
        $this->db->or_where($where_or);
        $this->db->group_end();
      }

      if($like){
        $this->db->group_start();
        $this->db->or_like($like);
        $this->db->group_end();
      }

      $query=$this->db->get($table);
      return $query->num_rows();
  }

  // Delete Rows
  function deleterows($table,$data){
    $this->db->where($data);
    $query= $this->db->delete($table);
  
    return $query; 
  }

  function getBodyContainer($data,$in=null){
    if(gettype($data)!=NULL){
      return (gettype($data)=='string')?$data['body']:$data['body']->container[$in];
    }else{  
      return false;
    }
  }


}
