<?php


class QueryModel extends CI_Model 
{

	function shop(){
 		return (
 			<<<QUERY
			  query {
			    shop {
			      name
			      email
			      createdAt
			      name
			      shopOwnerName
			      currencyFormats{
			      	moneyFormat
			      	moneyWithCurrencyFormat
			      }
			      
			    }
			  }
			QUERY );
 	}

 	function getWebhook($topics='APP_UNINSTALLED'){
 		
 		return(
 			 <<<QUERY
				  query {
				    webhookSubscriptions(first: 10 , topics: $topics) {
				      edges {
				        node {
				          id
				          topic
				          endpoint {
				            __typename
				            ... on WebhookHttpEndpoint {
				              callbackUrl
				            }
				            ... on WebhookEventBridgeEndpoint {
				              arn
				            }
				            ... on WebhookPubSubEndpoint {
				              pubSubProject
				              pubSubTopic
				            }
				          }
				        }
				      }
				    }
				  }
				QUERY
 		);
 	}

 	// get Collection
 	function collectionByIdWithProducts($id,$limit=25){
 		return (<<<QUERY
			  query {
			    collection(id: "gid://shopify/Collection/$id") {
			      id
			      title
			      handle
			      products(first: $limit) {
			        nodes {
			          id
			          title
			          handle
			          vendor
			          totalInventory
			          tracksInventory
			          variants(first: 1) {
				          nodes {
				            id
				            price
				            compareAtPrice
				          }
				        }
				        featuredMedia{
				        	preview{
				        		image{
				        			id
				        			url
				        		}
				        	}
				        }
			        }
			      }
			    }
			  }
			QUERY);
 	}
 	//End query function 


 	function collections($filters='first:250'){
 		return (<<<QUERY
			  query {
			    collections($filters) {
			      edges {
			        node {
			          id
			          title
			          handle
			          updatedAt
			          sortOrder
			        }
			      }
			    }
			  }
			QUERY);
 	}
 	//End query function 

 	//get page
 	function page(){
 			return ('
 				 query PageShow($id: ID!) {
				    page(id: $id) {
				      id
				      body
				    }
				  }
 			');	
 	}

 	//  get Pages
 	function pages()
  {
  	// code...
  	return(
  		'
  			query PageList {
					  pages(first: 100) {
					    edges {
					      node {
					        id
					        title
					        handle
					      }
					    }
					  }
				}
  		'
  	);
  }	//  End get query Pages


 	//start mutation function 
 	function webhookCreate(){
 		return(
 			'
			  mutation webhookSubscriptionCreate($topic: WebhookSubscriptionTopic!, $webhookSubscription: WebhookSubscriptionInput!) {
			    webhookSubscriptionCreate(topic: $topic, webhookSubscription: $webhookSubscription) {
			      webhookSubscription {
			        id
			        topic
			        filter
			        format
			        endpoint {
			          __typename
			          ... on WebhookHttpEndpoint {
			            callbackUrl
			          }
			        }
			      }
			      userErrors {
			        field
			        message
			      }
			    }
			  }
			'
 		);
 	}

 	function webhookDelete(){
 		return(
 			'
				  mutation webhookSubscriptionDelete($id: ID!) {
				    webhookSubscriptionDelete(id: $id) {
				      userErrors {
				        field
				        message
				      }
				      deletedWebhookSubscriptionId
				    }
				  }
			'
 		);
 	}

 	function subscriptionCreate(){
 
 		return(
 			'mutation AppSubscriptionCreate($name: String!, $lineItems: [AppSubscriptionLineItemInput!]!, $returnUrl: URL! ,$test:Boolean,$trialDays:Int){
                appSubscriptionCreate(name: $name, returnUrl: $returnUrl, lineItems: $lineItems,test:$test,trialDays:$trialDays) {
                  userErrors {
                    field
                    message
                  }
                  appSubscription {
                    id
                  }
                  confirmationUrl
                }
              }
            '
 		);
 	}// End subscription

 	function pageUpdate(){
 		return(
 			'mutation UpdatePage($id: ID!, $page: PageUpdateInput!) {
				  pageUpdate(id: $id, page: $page) {
				    page {
				      id
				      title
				      handle
				    }
				    userErrors {
				      code
				      field
				      message
				    }
				  }
				}'
 		);
 	}


 	// End Mutation query

 	function getBodyContainer($data,$in=null){
    if(gettype($data)!=NULL){
      return (gettype($data)=='string')?$data['body']:$data['body']->container['data'][$in];
    }else{  
      return false;
    }
  }
}