<!-- Offer products modal -->

        <div class="modal" id="offerProducts" tabindex="-1" aria-labelledby="selectProductLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg ">
              <div class="modal-content">
                <div class="modal-header bg-transparent">
                  <h3>Add Products</h3>  
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body pb-5 px-sm-5 mx-50">
                    <div class="input-group mb-3">
                        <input type="text" class="form-control" v-model="productSearch" placeholder="Search (Please type full name of product to search the product in list)" aria-describedby="button-addon2">
                  
                      
                        <button class="btn btn-outline-secondary" id="button-addon2" type="button" @click='searchForGetProduct'>Search</button>
                      
                    </div>
                    <div class="d-flex justify-content-center" v-if="loading==true">
                        <div class="spinner-grow" style="width: 4rem; height: 4rem;"  role="status">
                          <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                    <ul class="list-group list-group-flush mb-2" >
                        <li class="list-group-item d-flex align-items-center border-0 border-bottom px-0 py-50" v-for="products in getProductsList" >
                            <div class="d-flex me-1" >
                                <div style="display: none;">{{}}</div>
                                <div class="form-check">
                                  <input class="form-check-input" type="checkbox" :value="products.id" :id="'productCheck-'+products.id" @click="productSelect($event,products.id)" v-model="offerProducts">
                                  <label class="form-check-label" :for="'productCheck-'+products.id"></label>
                                </div>
                            </div>
                            <div class="avatar  me-1">
                              <img v-if="products.images.length>0" v-bind:src="products.images[0]?.src+'&width=50'" alt="avatar" width="38" height="38">
                            </div>
                            <div class="d-flex align-items-center justify-content-between w-100">
                              <div class="me-1">
                                <h5 class="mb-25">{{products.title}}</h5>
                              </div>
                            </div>
                        </li>
                    </ul>
                    
                    <div class="btn-toolbar justify-content-center" role="toolbar" v-if="getProductsLink.next">
                        <div class="btn-group " role="group" >
                            <button type="button" class="btn btn-outline-primary" @click="getProduct(getProductsLink.previous)"><i class="fa-solid fa-chevron-left"></i></button>
                            <button type="button" class="btn btn-outline-primary" @click="getProduct(getProductsLink.next)"><i class="fa-solid fa-chevron-right"></i></button>
                        </div>
                    </div>
                </div>  
                <div class="modal-footer">
                    
                    <button class="btn btn-primary" data-bs-dismiss="modal">Save</button>
                </div>
              </div>
            </div>
        </div> <!--End products modal-->