var revonvertFunction=function(jqRe){

	let enapRecCheckout=  (typeof Shopify.Checkout !='undefined')?Shopify.Checkout:'';
	if(enapRecCheckout){
		let checkoutOrders= Shopify.checkout;
		let OrderStatus= enapRecCheckout.OrderStatus
		let enapRecFunctions={
			settings:{},
			baseUrl:"https://james.enormapps.com/reconvert/",
			postData:async function (url='', data={},type='POST') {
	            const response = await fetch(url, {
	                method: type,
	                body: data
	                
	            });
	            return response.json();
			},
			getProducts:function () {
				let products=this.getCheckoutProduct();
				let subTotal= Shopify.checkout.subtotal_price
				let total= Shopify.checkout.total_price
				let prices= this.getCheckoutProductPrice()
				let productsTitles=this.getCheckoutProductTitle();
				let itemCount=Shopify.checkout.line_items.length
				var formData= new FormData();
	        		formData.append("shop",Shopify.shop);
					formData.append("products",products);
					formData.append("productsTitles",productsTitles);
					formData.append("prices",prices);
					formData.append("subTotal",subTotal);
					formData.append("total",subTotal);
					formData.append("itemCount",itemCount);
			    let callUri=(Shopify.shop=="james-develop.myshopify.com")?"api/get-products":"api/get-products";
				let uri= this.baseUrl+callUri;
				
				let self= this;
				this.postData(uri,formData).then(req=>{
					if(typeof req =="object"){
						let offers=req.offers;
						self.settings=req;
						let productsSer=req.products
						offers.forEach((offer,index)=>{
							let id= offer.id;
							if(offer.position=="right"){
								enapRecFunctions.addRightDiv(index);
							}else{
								enapRecFunctions.addDiv(index);	
							}

							let layoutType=(offer.layout==null)?"slider":offer.layout.type;
							
							let products='';
							let i=1;
							let title= `<h2>${offer.language.title}</h2>`
							
							let productIds=offer.products.split(',');
							
							productIds.forEach((id,prIndex)=>{
								if (typeof productsSer[id] !== "undefined") { 
									products+=enapRecFunctions.productTemplate(productsSer[id],offer,index,prIndex);
							   }
							})
							// offer.products.forEach((pro,prIndex)=>{
							// 	products+=enapRecFunctions.productTemplate(pro,offer,index,prIndex);
							// })	
							
							//jqRe("#enap-reconvert").append(products);
							document.getElementById("enap-title-"+index).innerHTML=title
							document.getElementById("enap-items-"+index).innerHTML=products;
							if(layoutType=="slider"){
								enapRecFunctions.productStyle(index,offer)
								if(offer.products.length>2 && offer.position=="left"){
									enapRecFunctions.sliderRun(".enap-reconvert-"+index);
								}else if(offer.products.length!=1 && offer.position=="right"){
									enapRecFunctions.sliderRun(".enap-reconvert-"+index,2);
								}
							}else{
								enapRecFunctions.productStyle(index,offer)
								let style=`<style>#enap-items-${index} { display: grid; grid-template-columns: auto auto auto; grid-gap: 10px; }#enap-items-${index} .enap-product-item{width: auto;}</style>`;
								jqRe("body").append(style);
							}
						})
						
					}
				})
			},
			getCheckoutProduct:function(){
				let checkout=Shopify.checkout.line_items;
				let products= []
				checkout.forEach(item=>{
					products.push(item.product_id);
				})
				return products.toString();
			},
			getCheckoutProductTitle:function(){
				let checkout=Shopify.checkout.line_items;
				let products= []
				checkout.forEach(item=>{
					products.push(item.title);
				})
				return products.toString();
			},
			getCheckoutProductPrice:function(){
				let checkout=Shopify.checkout.line_items;
				let products= []
				checkout.forEach(item=>{
					products.push(item.price);
				})
				return products.toString();
			},
			addDiv: function(id){
				OrderStatus.addContentBox("<div class='enap-reconvert' id='enap-reconvert-"+id+"'><div id='enap-title-"+id+"'></div><div class='swiper enap-reconvert-"+id+"'><div id='enap-items-"+id+"' class='swiper-wrapper enap-items-"+id+"'></div></div></div>");
			},
			addRightDiv:function (id) {
				// body...
				jqRe(".sidebar .sidebar__content").append("<div class='enap-reconvert' id='enap-reconvert-"+id+"'><div id='enap-title-"+id+"'></div><div class='swiper enap-reconvert-"+id+"'><div id='enap-items-"+id+"' class='swiper-wrapper enap-items-"+id+"'></div></div></div>")
			},
			productTemplate:function(product,offer,index,prIndex){
			
				let langu= offer.language;
				let type= offer.offer.discount
				let value=offer.offer.discountValue;
				let discountValue;

				if(type=="fixed"){
					discountValue=this.discountFix(product.variants[0].price,value);
				}else if(type=="percent"){
					discountValue=this.discountPercent(product.variants[0].price,value);
				}else{
					discountValue=product.variants[0].price;
				}
				return `
					<div class="enap-product-item swiper-slide" >
						<div class="enap-product">
							<div class="enap-product-image">
								<img src="${product.images[0].src+"&width=350"}"/>
							</div>
							<div class="enap-product-title"><span>${product.title}</span></div>
							<div class="enap-product-price"><span class="enap-sale-price">${this.getPrice(discountValue)}</span> <span class="enap-regular-price"><del>${this.getPrice(product.variants[0].price)}</del></span></div>
							<div class="enap-product-button"><button class="enap-button" data-varid="${product.variants[0].id}" data-id="${index}" data-price="${discountValue}" data-compare-price="${product.variants[0].price}" data-prid="${prIndex}">${langu.buyNowButton}</button></div>
						</div>
					</div>
				`;
			},
			productStyle:function(index,offer){
				let design= offer.design;
				let addCss=`.sidebar .sidebar__content .order-summary__sections{
					height:auto;
				}`
				let style=`
				    .content-box__row{
				    	display: inline-block;
				    }
					#enap-reconvert-${index} h2{
						color: ${design.hdTextColor};
						text-align:center;
						margin-bottom:.5rem
					} 
					#enap-reconvert-${index} .enap-product-item{
					    width: ${offer.position=="right"?'90%;':'32.9%;'}
					    float: left;
					    padding: 1px;
					    text-align: center;
					}
					#enap-reconvert-${index} .enap-product {
					    padding: 5px;
					    background-color:${design.proBgColor};
					   
					}
					#enap-reconvert-${index} .enap-product-item img {
					    width: 100%;
					}
					#enap-reconvert-${index} .enap-product-title{
					    color: ${design.prTextColor};
					    margin-bottom:.3rem;
					}
					#enap-reconvert-${index} enap-product-price,#enap-reconvert-${index} .enap-product-item{
						margin-bottom:.3rem;	
					}
					#enap-reconvert-${index} .enap-product-item button {
					    background: ${design.bnBgColor};
					    padding: 8px 20px;
					    border-radius: 5px;
					    font-size: 16px;
					    color: ${design.bnTextColor};
					}
					#enap-reconvert-${index} .enap-product-item button svg path {
					    fill: ${design.bnTextColor};
					}
					#enap-reconvert-${index} .enap-regular-price{
						color:${design.priceColor};
						font-size:14px;
					}	
					#enap-reconvert-${index} .enap-sale-price{
						font-size:16px;
						color:${design.discountPriceColor};
					}
					${addCss}
				`
			
				// document.body.innerText +=style
				jqRe("body").append("<style>"+style+"</style>");
			},
			discountPercent:function($val,discountValue){
				let price = $val- ($val * (discountValue / 100));
		          return price.toFixed(2)
		    },
		    discountFix:function($val,discountValue){
		        let price = $val- discountValue;
		        return price.toFixed(2)
		    },
		    getPrice:function(price){
		    	return this.settings?.withoutCurrency.replace("{{amount}}",price);
		    },
		    sliderRun:function($id,length=3){

		    	console.log();
		    	let sliderCallLen=jqRe($id).find('.enap-product-item').length;
		    	if(sliderCallLen<length){
		    		return false
		    	}
		    	jqRe($id).parents(".content-box__row").css("display","block")
		    	jqRe($id).append(`<div class="swiper-button-prev"></div><div class="swiper-button-next"></div>`)
		    	let swiper=new Swiper ($id, {
				    speed: 400,
				    spaceBetween: 100,
				    initialSlide: 0,
				    //truewrapper adoptsheight of active slide
				    autoHeight: true,
				    // Optional parameters
				    direction: 'horizontal',
				    loop: true,
				    // delay between transitions in ms
				    autoplay: false,
				    autoplayStopOnLast: false, // loop false also
				    // If we need pagination
				    pagination: '.swiper-pagination',
				    paginationType: "bullets",
				    
				    // Navigation arrows
				    navigation: {
			          nextEl: ".swiper-button-next",
			          prevEl: ".swiper-button-prev",
			        },
				    
				    // And if we need scrollbar
				    //scrollbar: '.swiper-scrollbar',
				    // "slide", "fade", "cube", "coverflow" or "flip"
				    effect: 'slide',
				    // Distance between slides in px.
				    spaceBetween: 20,
				    //
				    slidesPerView: length,
				    //
				    centeredSlides: false,
				    //
				    slidesOffsetBefore: 0,
				    //
				    grabCursor: true,
				  })   

		    	console.log("...swiper..",swiper)
				
		    },
		    loadScript:function(){
		    	const scriptSwiper = document.createElement('script');
				scriptSwiper.src = 'https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js';
				document.body.appendChild(scriptSwiper);
		    },
		    loadCss:function() {
		    	// body...
		    	const cssSwiper = document.createElement('link');
				cssSwiper.href = 'https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css';
				cssSwiper.rel = 'stylesheet';
				document.body.appendChild(cssSwiper);

				const cssCustome = document.createElement('link');
				cssCustome.href = this.baseUrl+'frontend/css/reconvert.min.css';
				cssCustome.rel = 'stylesheet';
				document.body.appendChild(cssCustome);
				
		    },
			init :function(){
                let reconvertVarId = sessionStorage.getItem("reconvertVarId")?sessionStorage.getItem("reconvertVarId"):0;
                if(reconvertVarId==0){
				    enapRecFunctions.loadScript()
					enapRecFunctions.loadCss()
					enapRecFunctions.getProducts();
				}	
			},
			loader:function() {
				// body...
				return `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 50 50">
						  <path fill="#fffff" d="M25,5A20.14,20.14,0,0,1,45,22.88a2.51,2.51,0,0,0,2.49,2.26h0A2.52,2.52,0,0,0,50,22.33a25.14,25.14,0,0,0-50,0,2.52,2.52,0,0,0,2.5,2.81h0A2.51,2.51,0,0,0,5,22.88,20.14,20.14,0,0,1,25,5Z">
						    <animateTransform attributeName="transform" type="rotate" from="0 25 25" to="360 25 25" dur="0.5s" repeatCount="indefinite"/>
						  </path>
						</svg>`
			}


		}

		enapRecFunctions.init()
		jqRe("body").on("click",".enap-button",function(){
			jqRe(this).html(enapRecFunctions.loader());
			let varId=jqRe(this).attr("data-varid")
			let index=jqRe(this).attr("data-id")
			let prIndex=jqRe(this).attr("data-prid")
			let discount=enapRecFunctions.settings.offers[index];
		
			let sad= checkoutOrders.shipping_address;

			let shippingAddress={
				address1: sad.address1,
				address2: sad.address1,
				city: sad.city,
				country: sad.country,
				country_code: sad.country_code,
				first_name: sad.first_name,
				last_name: sad.last_name,
				province: sad.province,
				province_code: sad.province_code,
				zip: sad.zip
			}
			let line_items=[
					{
						variant_id:varId,
						quantity:1,
					}
				]
				// compare_at_price:
						// price:
			var checkoutDetails={
				shop:Shopify.shop,
				shippingAddress:shippingAddress,
				email:checkoutOrders.email,
				customerId:checkoutOrders.customer_id,
				line_items:line_items,
				id:discount.id
			}

			let uri = enapRecFunctions.baseUrl+"api/checkout";
				
				var saveData = $.ajax({
				      type: 'POST',
				      url: uri,
				      data: checkoutDetails,
				      dataType: "json",
				      success: function(resultData) {
                        sessionStorage.setItem("reconvertVarId", varId);
				      	window.location.href=resultData.web_url
				      }
				});
				saveData.error(function() { alert("Something went wrong"); });
		})
	}
	
}

if(typeof jQuery =="undefined"){
	const script = document.createElement('script');
	script.src = 'https://cdnjs.cloudflare.com/ajax/libs/jquery/2.2.4/jquery.min.js';
	document.body.appendChild(script);
	script.onload = function($) {
      	revonvertFunction(window.jQuery);
    }

}else{
	revonvertFunction(window.jQuery);
}